/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content;

import com.hlysine.create_power_loader.CPLBlockEntityTypes;
import com.hlysine.create_power_loader.content.AbstractChunkLoaderBlockEntity;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.WeakCollection;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.utility.Pair;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ChunkLoadManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SAVED_CHUNKS_DISCARD_TICKS = 100;
    private static final List<Pair<UUID, Set<LoadedChunkPos>>> unforceQueue = new LinkedList<Pair<UUID, Set<LoadedChunkPos>>>();
    private static final Map<UUID, Set<LoadedChunkPos>> savedForcedChunks = new HashMap<UUID, Set<LoadedChunkPos>>();
    private static int savedChunksDiscardCountdown = 100;
    public static Level tickLevel;
    public static final Map<LoaderMode, WeakCollection<ChunkLoader>> allLoaders;

    public static void addLoader(LoaderMode mode, ChunkLoader loader) {
        allLoaders.computeIfAbsent(mode, $ -> new WeakCollection()).add(loader);
    }

    public static void removeLoader(LoaderMode mode, ChunkLoader loader) {
        allLoaders.computeIfAbsent(mode, $ -> new WeakCollection()).remove(loader);
    }

    public static void onServerWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        MinecraftServer server = event.level.m_7654_();
        if (savedChunksDiscardCountdown == 0) {
            for (Map.Entry<UUID, Set<LoadedChunkPos>> entry : savedForcedChunks.entrySet()) {
                ChunkLoadManager.unforceAllChunks(server, entry.getKey(), entry.getValue());
            }
            savedForcedChunks.clear();
        } else if (savedChunksDiscardCountdown > 0) {
            --savedChunksDiscardCountdown;
        }
        if (!unforceQueue.isEmpty()) {
            for (Pair pair : unforceQueue) {
                ChunkLoadManager.unforceAllChunks(server, (UUID)pair.getFirst(), (Set)pair.getSecond());
            }
            unforceQueue.clear();
        }
    }

    public static <T extends Comparable<? super T>> void updateForcedChunks(MinecraftServer server, LoadedChunkPos center, T owner, int loadingRange, Set<LoadedChunkPos> forcedChunks) {
        Set<LoadedChunkPos> targetChunks = ChunkLoadManager.getChunksAroundCenter(center, loadingRange);
        ChunkLoadManager.updateForcedChunks(server, targetChunks, owner, forcedChunks);
    }

    public static <T extends Comparable<? super T>> void updateForcedChunks(MinecraftServer server, Collection<LoadedChunkPos> centers, T owner, int loadingRange, Set<LoadedChunkPos> forcedChunks) {
        HashSet<LoadedChunkPos> targetChunks = new HashSet<LoadedChunkPos>();
        for (LoadedChunkPos center : centers) {
            targetChunks.addAll(ChunkLoadManager.getChunksAroundCenter(center, loadingRange));
        }
        ChunkLoadManager.updateForcedChunks(server, targetChunks, owner, forcedChunks);
    }

    public static <T extends Comparable<? super T>> void updateForcedChunks(MinecraftServer server, Collection<LoadedChunkPos> newChunks, T owner, Set<LoadedChunkPos> forcedChunks) {
        HashSet<LoadedChunkPos> unforcedChunks = new HashSet<LoadedChunkPos>();
        for (LoadedChunkPos chunk : forcedChunks) {
            if (newChunks.contains(chunk)) {
                newChunks.remove(chunk);
                continue;
            }
            ChunkLoadManager.forceChunk(server, owner, chunk.dimension(), chunk.x(), chunk.z(), false);
            unforcedChunks.add(chunk);
        }
        forcedChunks.removeAll(unforcedChunks);
        for (LoadedChunkPos chunk : newChunks) {
            ChunkLoadManager.forceChunk(server, owner, chunk.dimension(), chunk.x(), chunk.z(), true);
            forcedChunks.add(chunk);
        }
        if (unforcedChunks.size() > 0 || newChunks.size() > 0) {
            LOGGER.debug("CPL: update chunks, unloaded {}, loaded {}.", (Object)unforcedChunks.size(), (Object)newChunks.size());
        }
    }

    public static void enqueueUnforceAll(UUID owner, Set<LoadedChunkPos> forcedChunks) {
        unforceQueue.add((Pair<UUID, Set<LoadedChunkPos>>)Pair.of((Object)owner, forcedChunks));
    }

    public static <T extends Comparable<? super T>> void unforceAllChunks(MinecraftServer server, T owner, Set<LoadedChunkPos> forcedChunks) {
        for (LoadedChunkPos chunk : forcedChunks) {
            ChunkLoadManager.forceChunk(server, owner, chunk.dimension(), chunk.x(), chunk.z(), false);
        }
        if (forcedChunks.size() > 0) {
            LOGGER.debug("CPL: unload all, unloaded {} chunks.", (Object)forcedChunks.size());
        }
        forcedChunks.clear();
    }

    private static Set<LoadedChunkPos> getChunksAroundCenter(LoadedChunkPos center, int radius) {
        HashSet<LoadedChunkPos> ret = new HashSet<LoadedChunkPos>();
        for (int i = center.x() - radius + 1; i <= center.x() + radius - 1; ++i) {
            for (int j = center.z() - radius + 1; j <= center.z() + radius - 1; ++j) {
                ret.add(new LoadedChunkPos(center.dimension(), i, j));
            }
        }
        return ret;
    }

    private static <T extends Comparable<? super T>> void forceChunk(MinecraftServer server, T owner, ResourceLocation dimension, int chunkX, int chunkZ, boolean add) {
        ServerLevel targetLevel = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimension));
        assert (targetLevel != null);
        if (owner instanceof BlockPos) {
            ForgeChunkManager.forceChunk((ServerLevel)targetLevel, (String)"create_power_loader", (BlockPos)((BlockPos)owner), (int)chunkX, (int)chunkZ, (boolean)add, (boolean)true);
        } else {
            ForgeChunkManager.forceChunk((ServerLevel)targetLevel, (String)"create_power_loader", (UUID)((UUID)owner), (int)chunkX, (int)chunkZ, (boolean)add, (boolean)true);
        }
    }

    public static Set<LoadedChunkPos> getSavedForcedChunks(UUID entityUUID) {
        return savedForcedChunks.remove(entityUUID);
    }

    public static void validateAllForcedChunks(ServerLevel level, ForgeChunkManager.TicketHelper helper) {
        helper.getBlockTickets().forEach((blockPos, tickets) -> {
            LOGGER.debug("CPL: Inspecting level {} position {} which has {} non-ticking tickets and {} ticking tickets.", new Object[]{level.m_46472_().m_135782_(), blockPos.m_123344_(), ((LongSet)tickets.getFirst()).size(), ((LongSet)tickets.getSecond()).size()});
            AbstractChunkLoaderBlockEntity blockEntity = level.m_141902_(blockPos, (BlockEntityType)CPLBlockEntityTypes.BRASS_CHUNK_LOADER.get()).orElse(null);
            if (blockEntity == null) {
                blockEntity = level.m_141902_(blockPos, (BlockEntityType)CPLBlockEntityTypes.ANDESITE_CHUNK_LOADER.get()).orElse(null);
            }
            if (blockEntity == null) {
                helper.removeAllTickets(blockPos);
                LOGGER.debug("CPL: level {} position {} unforced: Cannot find block entity.", (Object)level.m_46472_().m_135782_(), (Object)blockPos.m_123344_());
                return;
            }
            for (Long chunk : (LongSet)tickets.getFirst()) {
                ChunkPos chunkPos = new ChunkPos(chunk.longValue());
                helper.removeTicket(blockPos, chunk.longValue(), false);
                LOGGER.debug("CPL: level {} position {} unforced non-ticking {}", new Object[]{level.m_46472_().m_135782_(), blockPos.m_123344_(), chunkPos});
            }
            HashSet<LoadedChunkPos> forcedChunks = new HashSet<LoadedChunkPos>();
            for (Long chunk : (LongSet)tickets.getSecond()) {
                ChunkPos chunkPos = new ChunkPos(chunk.longValue());
                forcedChunks.add(new LoadedChunkPos(level.m_46472_().m_135782_(), chunkPos));
            }
            blockEntity.reclaimChunks(forcedChunks);
            LOGGER.debug("CPL: level {} position {} reclaimed {} chunks.", new Object[]{level.m_46472_().m_135782_(), blockPos.m_123344_(), forcedChunks.size()});
        });
        helper.getEntityTickets().forEach((entityUUID, tickets) -> {
            Set<Object> savedChunks = new HashSet();
            if (savedForcedChunks.containsKey(entityUUID)) {
                savedChunks = savedForcedChunks.get(entityUUID);
            }
            for (Long chunk : (LongSet)tickets.getFirst()) {
                savedChunks.add(new LoadedChunkPos((Level)level, chunk));
            }
            for (Long chunk : (LongSet)tickets.getSecond()) {
                savedChunks.add(new LoadedChunkPos((Level)level, chunk));
            }
            savedForcedChunks.put((UUID)entityUUID, (Set<LoadedChunkPos>)savedChunks);
            LOGGER.debug("CPL: Inspecting entity {} which has {} non-ticking tickets and {} ticking tickets.", new Object[]{entityUUID, ((LongSet)tickets.getFirst()).size(), ((LongSet)tickets.getSecond()).size()});
        });
        savedChunksDiscardCountdown = 100;
    }

    public static void reclaimChunks(Level level, UUID owner, Map<ResourceKey<Level>, Set<LoadedChunkPos>> reclaimedChunks) {
        Set<LoadedChunkPos> oldChunks = ChunkLoadManager.getSavedForcedChunks(owner);
        if (oldChunks != null) {
            for (LoadedChunkPos chunk : oldChunks) {
                ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)chunk.dimension());
                Set<LoadedChunkPos> reclaim = reclaimedChunks.get(key);
                if (reclaim != null) {
                    reclaim.add(chunk);
                    continue;
                }
                reclaim = new HashSet<LoadedChunkPos>();
                reclaim.add(chunk);
                reclaimedChunks.put((ResourceKey<Level>)key, reclaim);
            }
        }
        if (!reclaimedChunks.isEmpty()) {
            MinecraftServer server = level.m_7654_();
            assert (server != null);
            Iterator<Map.Entry<ResourceKey<Level>, Set<LoadedChunkPos>>> iterator = reclaimedChunks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<Level>, Set<LoadedChunkPos>> entry = iterator.next();
                ServerLevel reclaimLevel = server.m_129880_(entry.getKey());
                if (reclaimLevel == null) continue;
                ChunkLoadManager.unforceAllChunks(server, owner, entry.getValue());
                iterator.remove();
            }
        }
    }

    static {
        allLoaders = new HashMap<LoaderMode, WeakCollection<ChunkLoader>>();
    }

    public record LoadedChunkPos(@NotNull ResourceLocation dimension, @NotNull ChunkPos chunkPos) {
        public LoadedChunkPos(@NotNull Level level, long chunkPos) {
            this(level.m_46472_().m_135782_(), new ChunkPos(chunkPos));
        }

        public LoadedChunkPos(@NotNull ResourceLocation level, int pX, int pZ) {
            this(level, new ChunkPos(pX, pZ));
        }

        public LoadedChunkPos(@NotNull Level level, BlockPos blockPos) {
            this(level.m_46472_().m_135782_(), new ChunkPos(blockPos));
        }

        public int x() {
            return this.chunkPos.f_45578_;
        }

        public int z() {
            return this.chunkPos.f_45579_;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LoadedChunkPos)) {
                return false;
            }
            LoadedChunkPos loadedChunk = (LoadedChunkPos)obj;
            if (!Objects.equals(loadedChunk.dimension, this.dimension)) {
                return false;
            }
            return Objects.equals(loadedChunk.chunkPos, this.chunkPos);
        }

        @Override
        public String toString() {
            return this.dimension + ":" + this.chunkPos;
        }
    }
}

